% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getB.R
\name{getB}
\alias{getB}
\title{Get the inferred regression coefficients}
\usage{
getB(m)
}
\arguments{
\item{m}{a model fitted with \code{jtdm_fit}}
}
\value{
A list containing:
   \item{Bsamples}{Sample from the posterior distribution of the regression coefficient matrix. It is an array where the first dimension is the number of traits, the second the number of columns in m$X (the number of variables after transformation via formula) and the third the number of MCMC samples.}
   \item{Bmean}{Posterior mean of the regression coefficient matrix.}
   \item{Bq975,Bq025}{97.5\% and 0.25\% posterior quantiles of the regression coefficient matrix.}
}
\description{
Get the samples from the posterior distribution of the regression coefficient matrix B, together with the posterior mean and quantiles. The regression coefficient matrix B is a matrix where the number of rows is defined by the number of traits that are modeled, and the number of columns is the number of columns of the matrix m$X (the number of explanatory variables after transformation via formula)
}
\examples{
data(Y)  
data(X)
m = jtdm_fit(Y=Y, X=X, formula=as.formula("~GDD+FDD+forest"), sample = 1000) 
# get the inferred regression coefficients
B=getB(m)
}
