% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{tracedens_jags}
\alias{tracedens_jags}
\title{Combination of trace plots and by-chain kernel densities of \code{jagsUI} object}
\usage{
tracedens_jags(
  x,
  p = NULL,
  exact = FALSE,
  parmfrow = NULL,
  lwd = 1,
  shade = TRUE,
  ...
)
}
\arguments{
\item{x}{Posterior \code{jagsUI} object}

\item{p}{Parameter name for subsetting: if this is specified, only parameters with names beginning with this string will be plotted.}

\item{exact}{Whether \code{p} should be an exact match (\code{TRUE}) or just match the
beginning of the string (\code{FALSE}).  Defaults to \code{FALSE}.}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{lwd}{Line width for plotting.  Defaults to 1.}

\item{shade}{Whether to add semi-transparent shading to by-chain kernel densities.  Defaults to \code{TRUE}.}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Combination of trace plots and by-chain kernel densities of a whole \code{jagsUI} object, or optional subset of parameter nodes.
}
\examples{

tracedens_jags(asdf_jags_out, parmfrow=c(4,2))
tracedens_jags(asdf_jags_out, p="a", parmfrow=c(3,1))
}
\seealso{
\link{trace_jags}, \link{chaindens_jags}, \link{pairstrace_jags}
}
\author{
Matt Tyers
}
