% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HallLittlewood.R
\name{HallLittlewoodPol}
\alias{HallLittlewoodPol}
\title{Hall-Littlewood polynomial}
\usage{
HallLittlewoodPol(n, lambda, which = "P")
}
\arguments{
\item{n}{number of variables}

\item{lambda}{integer partition}

\item{which}{which Hall-Littlewood polynomial, \code{"P"} or \code{"Q"}}
}
\value{
The Hall-Littlewood polynomial in \code{n} variables of the
  integer partition \code{lambda}. This is a \code{symbolicQspray}
  polynomial with a unique parameter usually denoted by \eqn{t} and
  its coefficients are polynomial in this parameter. When substituting
  \eqn{t} with \eqn{0} in the Hall-Littlewood \eqn{P}-polynomials, one
  obtains the Schur polynomials.
}
\description{
Hall-Littlewood polynomial of a given partition.
}
