% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.test.R
\name{jaccard.test}
\alias{jaccard.test}
\title{Test for Jaccard/Tanimoto similarity coefficients}
\usage{
jaccard.test(x, y, method = "mca", px = NULL, py = NULL, verbose = TRUE,
  ...)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{method}{a method to compute a p-value (\code{"mca"}, \code{"bootstrap"}, \code{"asymptotic"}, or \code{"exact"})}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}

\item{verbose}{whether to print progress messages}

\item{...}{optional arguments for specific computational methods}
}
\value{
\code{jaccard.test} returns a list mainly consisting of
\item{statistics}{centered Jaccard/Tanimoto similarity coefficient}
\item{pvalue}{p-value}
\item{expectation}{expectation}
}
\description{
Compute statistical significance of Jaccard/Tanimoto similarity coefficients between binary vectors, using four different methods.
}
\details{
There exist four methods to compute p-values of Jaccard/Tanimoto similarity coefficients:
\code{mca}, \code{bootstrap}, \code{asymptotic}, and \code{exact}. This is simply a wrapper function for
corresponding four functions in this package: \link{jaccard.test.mca}, \link{jaccard.test.bootstrap},  \link{jaccard.test.asymptotic}, and \link{jaccard.test.exact}.

We recommand using either \code{mca} or \code{bootstrap} methods,
since the \code{exact} solution is slow for a moderately large vector and \code{asymptotic} approximation may be inaccurate depending on the input vector size.
The {bootstrap} method uses resampling with replacement binary vectors to compute a p-value (see optional arguments).
The \code{mca} method uses the measure concentration algorithm that estimates the multinomial distribution with a known error bound (specified by an optional argument \code{accuracy}).
}
\section{Optional arguments for \code{method="bootstrap"}}{

\describe{
  \item{fix}{whether to fix (i.e., not resample) \code{x} and/or \code{y}}
  \item{B}{a total bootstrap iteration}
  \item{seed}{a seed for a random number generator}
}
}

\section{Optional arguments for \code{method="mca"}}{

\describe{
  \item{accuracy}{an error bound on approximating a multinomial distribution}
  \item{error.type}{an error type on approximating a multinomial distribution (\code{"average"}, \code{"upper"}, \code{"lower"})}
  \item{seed}{a seed for the random number generator.}
}
}

\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard.test(x,y,method="bootstrap")
jaccard.test(x,y,method="mca")
jaccard.test(x,y,method="exact")
jaccard.test(x,y,method="asymptotic")
}
\seealso{
\link{jaccard.test.bootstrap} \link{jaccard.test.mca} \link{jaccard.test.exact} \link{jaccard.test.asymptotic}
}
