% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivx_ar.R
\name{ivx_ar}
\alias{ivx_ar}
\alias{print.ivx_ar}
\title{Fitting IVX-AR Models}
\usage{
ivx_ar(
  formula,
  data,
  horizon,
  ar = "auto",
  ar_ic = c("bic", "aic", "aicc"),
  ar_max = 5,
  ar_grid = function(x) seq(x - 0.3, x + 0.3, by = 0.02),
  na.action,
  contrasts = NULL,
  offset,
  model = TRUE,
  x = FALSE,
  y = FALSE,
  ...
)

\method{print}{ivx_ar}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted.}

\item{data}{n optional data frame, list or environment (or object coercible by
\code{\link[base:as.data.frame]{as.data.frame}} to a data frame) containing
the variables in the model. If not found in data, the variables are taken
from environment(formula), typically the environment from which lm is called.}

\item{horizon}{is the horizon (default horizon = 1 corresponds to a
short-horizon regression).}

\item{ar}{Method to include the autoregressive terms. "auto" find the optimal
ar order by using the information criteria. \code{ar = 0} reduces to simple \code{\link{ivx}}.
\code{ar > 1} uses a fixed order to estimate the model.}

\item{ar_ic}{Information criterion to be used in model selection.}

\item{ar_max}{Maximum ar order of model to fit.}

\item{ar_grid}{The ar grid sequence of which to iterate.}

\item{na.action}{a function which indicates what should happen when the data
contain NAs. The default is set by the na.action setting of \code{\link[base:options]{options}},
and is \code{\link[stats:na.fail]{na.fail}} if that is unset. The ‘factory-fresh’
default is \code{\link[stats:na.fail]{na.omit}}. Another possible value is \code{NULL},
no action. Value \code{\link[stats:na.fail]{na.exclude}} can be useful.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of
\code{\link[stats:model.matrix]{model.matrix.default}}.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be NULL or a
numeric vector or matrix of extents matching those of the response. One or
more offset terms can be included in the formula instead or as well, and if more
than one are specified their sum is used. See \link[stats:model.extract]{model.offset}}

\item{model}{logical. If \code{TRUE} the model.frame of the fit is returned.}

\item{x}{an object of class "ivx_ar", usually, a result of a call to ivx_ar.}

\item{y}{logical. If \code{TRUE} the response of the fit is returned.}

\item{...}{additional arguments to be passed to the low level regression fitting
functions (see \link[stats:lm]{lm}).}

\item{digits}{the number of significant digits to use when printing.}
}
\description{
ivx_ar implements the Yang et al (2020) new instrumental variable based Wald statistic
(IVX-AR) which accounts for serial correlation and heteroscedasticity in the error
terms of the linear predictive regression model.
}
\examples{

ivx_ar(hpi ~ log(res) + cpi, ylpc)

ivx_ar(hpi ~ log(res) + cpi, ylpc, ar_ic = "aic")

ivx_ar(hpi ~ log(res) + cpi, ylpc, ar = 1)

}
\references{
Yang, B., Long, W., Peng, L., & Cai, Z. (2020). Testing the
Predictability of US Housing Price Index Returns Based on an IVX-AR Model.
Journal of the American Statistical Association, 1-22. DOI:
\doi{10.1080/01621459.2019.1686392}
}
