% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{import}
\alias{import}
\title{Constructor of a Custom Instances of the Specimen Class}
\usage{
import(specie, genotype)
}
\arguments{
\item{specie}{an instance of the R6 class Specie with the genome's parameters.}

\item{genotype}{a named character vector with the coded/phased genotypes.}
}
\value{
Objects of R6 class with methods to mimic in silico Specimens.
}
\description{
Constructor of instances of the Specimen class given the Specie
    from which the individual will belong where the loci will equal to the
    provided genotype from two strings one for each homologous.
}
\examples{
data(ToyMap)
spc <- set_specie(ToyMap)

## simulating what is very close to your real genotypes
Real <- sample(c('2 2', '2 1', '1 2', '1 1'), size = nrow(ToyMap), replace = TRUE)
names(Real) <- ToyMap$snp # ensure snp names!

## now you can play _in silico_
Virtual <- import(spc, Real)
S1 <- Virtual$selfcross(n = 10)

}
