% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{set_specie}
\alias{set_specie}
\title{Constructor of Instances of the Specie Class}
\usage{
set_specie(data, meiosis = NULL)
}
\arguments{
\item{data}{A data frame with the map of the Genome to be simulates.}

\item{meiosis}{A pointer to a C++ function of the meiosis process.}
}
\value{
Objects of R6 class with methods to mimic in silico Genomes.
}
\description{
Constructor of instances of the Specie class given the map of
    the genome and optionally a pointer to a C++ function which will drive
    the meiosis process.
}
\examples{
data(ToyMap)
spc_standard <- set_specie(ToyMap)

## generate standard _de novo_ variability
spc_standard$gamete(n = 100)

\dontrun{
## writing your own meiosis process and using it
Meiosis <- '
// [[Rcpp::plugins(cpp11)]]
// [[Rcpp::depends(BH, isqg)]] 
# include <isqg.h> // loading headers of the package

// half w/ crossing at position 1.0
Map meiosis(const double & i, const double & j) {

  if (static_cast<bool>(R::rbinom(1.0, 0.5))) {
    return Map() ;
  } else {
    return Map(1, 1.0) ;
  }

}

// wrap the function as external pointer
// [[Rcpp::export]]
MPtr myMeiosis() { return MPtr(new FPtrM(& meiosis), true) ; }
'

## compile the code
Rcpp::sourceCpp(code = Meiosis, rebuild = TRUE)

## define a specie w/ custom meiosis
spp_custom <- set_specie(ToyMap, meiosis = myMeiosis())

## check meiosis process
spp_custom$gamete(n = 100)
}

}
