% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isco_soc_crosswalk.R
\name{isco_soc_crosswalk}
\alias{isco_soc_crosswalk}
\title{ISCO to SOC crosswalk}
\usage{
isco_soc_crosswalk(
  data,
  isco_lvl = 3,
  soc_lvl = "soc_2",
  brkd_cols = NULL,
  indicator = FALSE
)
}
\arguments{
\item{data, }{data.table with mandatory columns \code{job} and \code{value}}

\item{isco_lvl, }{numeric between 1 and 3}

\item{soc_lvl, }{character taking values from \code{soc_1} to \code{soc_4}}

\item{brkd_cols, }{character vector with col names of stratification variables}

\item{indicator, }{Boolean indicating if data describe an indicator. If \code{TRUE}
the mean value is computed, otherwise the sum by each breakdown group.}
}
\value{
\code{data.table} with the estimated values for the requested SOC
occupational group.
}
\description{
The 2010 Standard Occupational Classification (SOC) and the
International Standard Classification of Occupations (ISCO-08) are compared.
To make the crosswalk more straightforward and hence more useful, the notion
of parsimony was applied. This means that while a task completed in the SOC
may appear in numerous ISCOs (or vice versa), the match in some of these
instances is just coincidental and adds unneeded complexity. This function
allows mapping of data from the top 3 ISCO levels to the 4 SOC groups.
}
\examples{
library(iscoCrosswalks)
library(data.table)

#from ISCO level 3 group to soc_1 occupations
path <- system.file("extdata", "isco_3_brkdwn_example.csv",
                    package = "iscoCrosswalks")
dat <- fread(path)
isco_soc_crosswalk(dat,
                   isco_lvl = 3,
                   soc_lvl = "soc_1",
                   brkd_cols = "gender")

}
\references{
\insertRef{hardy2018educational}{iscoCrosswalks}
}
