% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clint_L1}
\alias{clint_L1}
\title{Clint Level-1 Example Data set}
\format{
A level-1 data.frame with 229 rows and 24 variables: \describe{
\item{\code{Lab.Sample.Name}}{Sample description used in the laboratory}
\item{\code{Date}}{Date the sample was added to the MS analyzer}
\item{\code{Compound.Name}}{Name of the test analyte/compound}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard - CCD)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Sample.Type}}{Type of Clint sample}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
\item{\code{Calibration}}{Identifier for mass spectrometry calibration -- usually the date}
\item{\code{ISTD.Name}}{Name of the internal standard (ISTD) analyte/compound}
\item{\code{ISTD.Conc}}{Concentration of ISTD (uM)}
\item{\code{ISTD.Area}}{Peak area of internal standard (pixels)}
\item{\code{Area}}{Peak area of analyte (target compound)}
\item{\code{Analysis.Method}}{General description of chemical analysis method}
\item{\code{Analysis.Instrument}}{Instrument(s) used for chemical analysis}
\item{\code{Analysis.Parameters}}{Parameters for identifing analyte peak (for example, retention time)}
\item{\code{Note}}{Any laboratory notes about sample}
\item{\code{Level0.File}}{Name of the laboratory data file from which the level-0 sample data was extracted}
\item{\code{Level0.Sheet}}{Name of the Excel workbook 'sheet' from which the level-0 sample data was extracted}
\item{\code{Time}}{Time when the sample was measured - in hours (h)}
\item{\code{Test.Compound.Conc}}{Measured concentration of analytic standard (for calibration curve) (uM)}
\item{\code{Test.Nominal.Conc}}{Expected initial concentration of chemical added to well (uM)}
\item{\code{Hep.Density}}{The density (units of millions of hepatocytes per mL) hepatocytes in the \emph{in vitro} incubation}
\item{\code{Biological.Replicates}}{Identifier for measurements of multiple samples with the same analyte}
\item{\code{Response}}{Response factor (calculated from analyte and ISTD peaks)}
}
}
\usage{
clint_L1
}
\description{
Mass Spectrometry measurements of intrinsic hepatic clearance (Clint) for cryopreserved 
pooled human hepatocytes. Chemicals were per- and poly-fluorinated alkyl substance
(PFAS) samples. The experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This data set is a subset of 
experimental data containing samples for 3 test analytes/compounds.
}
\references{
\insertRef{shibata2002prediction}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
