% Generated by roxygen2 (4.0.2): do not edit by hand
\name{invest}
\alias{invest}
\alias{invest.lm}
\alias{invest.lme}
\alias{invest.nls}
\title{Calibration for Linear and Nonlinear Regression Models.}
\usage{
invest(object, ...)

\method{invest}{lm}(object, y0, interval = c("inversion", "Wald", "none"),
  level = 0.95, mean.response = FALSE, data, boot = FALSE,
  type = c("parametric", "nonparametric"), nsim = 1, seed = NULL,
  progress = FALSE, lower, upper, tol = .Machine$double.eps^0.25,
  maxiter = 1000, adjust = c("none", "Bonferroni"), k, ...)

\method{invest}{nls}(object, y0, interval = c("inversion", "Wald", "none"),
  level = 0.95, mean.response = FALSE, data, boot = FALSE,
  type = c("parametric", "nonparametric"), nsim = 1, seed = NULL,
  progress = FALSE, lower, upper, tol = .Machine$double.eps^0.25,
  maxiter = 1000, adjust = c("none", "Bonferroni"), k, ...)

\method{invest}{lme}(object, y0, interval = c("inversion", "Wald", "none"),
  level = 0.95, mean.response = FALSE, data, lower, upper, q1, q2,
  tol = .Machine$double.eps^0.25, maxiter = 1000, ...)
}
\arguments{
\item{object}{An object that inherits from class \code{"lm"}, \code{"nls"},
or \code{"lme"}.}

\item{...}{Additional optional arguments. At present, no optional arguments
are used.}

\item{y0}{The value of the observed response(s) or specified value of the
mean response.}

\item{interval}{The type of interval required.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for
the interval to be calculated.}

\item{mean.response}{Logical indicating whether confidence intervals should
              correspond to an individual response (\code{FALSE}) or a
              mean response
(\code{TRUE}).}

\item{data}{An optional data frame. This is required if \code{object$data}
is \code{NULL}.}

\item{boot}{Logical indicating whether to carry out a bootstrap simulation.}

\item{type}{Character string specifying the type of bootstrap,
\code{"parametric"} or \code{"nonparametric"}.}

\item{nsim}{Positive integer specifying the number of bootstrap simulations;
the bootstrap B (or R).}

\item{seed}{Optional argument to \code{set.seed}.}

\item{progress}{Logical indicating whether to display a text-based progress
bar during the bootstrap simulation.}

\item{lower}{The lower endpoint of the interval to be searched.}

\item{upper}{The upper endpoint of the interval to be searched.}

\item{tol}{The desired accuracy passed on to \code{uniroot}. Recommend a
minimum of 1e-10.}

\item{maxiter}{The maximum number of iterations passed on to \code{uniroot}.}

\item{adjust}{A logical value indicating if an adjustment should be made to
the critical value used in calculating the confidence interval.
This is useful for when the calibration curve is to be used
multiple, say k, times.}

\item{k}{The number times the calibration curve is to be used for computing a
confidence interval. Only needed when \code{adjust = "Bonferroni"}.}

\item{q1}{Optional lower cutoff to be used in forming confidence intervals.
Only used when \code{object} inherits from class \code{"lme"}. Defaults to
\code{qnorm((1+level)/2)}.}

\item{q2}{Optional upper cutoff to be used in forming confidence intervals.
Only used when \code{object} inherits from class \code{"lme"}. Defaults to
\code{qnorm((1-level)/2)}.}
}
\value{
If \code{boot = FALSE}, then an object of class \code{"calibrate"}
        containing the following components:
  \itemize{
    \item \code{estimate} The estimate of x0.
    \item \code{lwr} The lower confidence limit for x0.
    \item \code{upr} The upper confidence limit for x0.
    \item \code{se} An estimate of the standard error (Wald interval only).
    \item \code{interval} The method used for calculating \code{lower} and
          \code{upper} (only used by \code{print} method).
  }
        Otherwise, an object of class \code{"bootCal"} containing the
        following components:
  \itemize{
    \item \code{original} The estimate of x0.
    \item \code{bootreps} The lower confidence limit for x0.
    \item \code{nsim} The number of bootstrap replicates.
    \item \code{level} The desired confidence level.
  }
}
\description{
The function \code{invest} computes the inverse estimate and a condfidence
interval for the unknown predictor value that corresponds to an observed
value of the response (or vector thereof) or specified value of the mean
response. See the references listed below for more details.
}
\examples{
##
## Nasturtium example (nonlinear regression with replication)
##

## Log-logistic model
mod <- nls(weight ~ theta1/(1 + exp(theta2 + theta3 * log(conc))),
           start = list(theta1 = 1000, theta2 = -1, theta3 = 1),
           data = nasturtium)

## Compute approximate 95\% calibration intervals
invest(mod, y0 = c(309, 296, 419), interval = "inversion")
invest(mod, y0 = c(309, 296, 419), interval = "Wald")

## Bootstrap calibration intervals
#boo <- invest(mod, y0 = c(309, 296, 419), boot = TRUE, nsim = 9999,
#              progress = TRUE, seed = 101)
#boo  # print bootstrap summary
#plot(boo)  # plot results
}
\references{
Greenwell, B. M., and Schubert Kabban, C. M. (2014). investr: An R Package
for Inverse Estimation. \emph{The R Journal}, \bold{6}(1), 90--100.
URL http://journal.r-project.org/archive/2014-1/greenwell-kabban.pdf.

Graybill, F. A., and Iyer, H. K. (1994).
\emph{Regression analysis: Concepts and Applications}. Duxbury Press.

Huet, S., Bouvier, A., Poursat, M-A., and Jolivet, E.  (2004)
\emph{Statistical Tools for Nonlinear Regression: A Practical Guide with S-PLUS and R Examples}. Springer.

Seber, G. A. F., and Wild, C. J. (1989)
\emph{Nonlinear regression}. Wiley.

Oman, Samuel D. (1998).
Calibration with Random Slopes.
\emph{Biometrics} \bold{85}(2): 439--449.
doi:10.1093/biomet/85.2.439.
}

