% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosLink}
\alias{CircosLink}
\title{Create a LINK module to a moduleList}
\usage{
CircosLink(
  modulename,
  compareGroup = 1,
  radius = 108,
  fillColor = "red",
  width = 3,
  type = "Q",
  displayLinkAxis = TRUE,
  axisColor = "#B8B8B8",
  axisWidth = 0.5,
  axisPad = 3,
  displayLinkLabel = TRUE,
  labelColor = "red",
  labelSize = 13,
  labelPad = 8,
  animationDisplay = FALSE,
  animationDirection = "1to2",
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{compareGroup}{The group number of thic module in compare module}

\item{radius}{Radius of link circle.}

\item{fillColor}{Color for link.}

\item{width}{Width for link.}

\item{type}{Type of link, could be Q/S/T}

\item{displayLinkAxis}{Whether display axis for link or not}

\item{axisColor}{The color for axis}

\item{axisWidth}{The width for axis}

\item{axisPad}{The pad for axis}

\item{displayLinkLabel}{Whether display label for link or not}

\item{labelColor}{The color for label}

\item{labelSize}{The size for label}

\item{labelPad}{The pad for label}

\item{animationDisplay}{Whether display animation}

\item{animationDirection}{The direction of link animation, could be 1to2 or 2to1}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of link with details including g1chr, g1start, g1end, g2chr, g2start, g2end, g1name, g2name,
fusion, link and html. Details can be found on document.}

\item{...}{Ignored}
}
\value{
The module tracks for link modules.
}
\description{
Link two specific region in genome.
}
\examples{
linkData<-linkExample
Circos(CircosLink('LINK', data = linkData,LinkRadius= 140,fillColor= "#9e9ac6",width= 2,
axisPad= 3,labelPad=8,animationDisplay=TRUE,animationDirection="1to2", animationType= "linear" ))

}
