% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_fmesher}
\alias{bru_mapper_fmesher}
\alias{ibm_n.bru_mapper_fmesher}
\alias{ibm_values.bru_mapper_fmesher}
\alias{ibm_jacobian.bru_mapper_fmesher}
\title{Mapper for general \code{fmesher} function space objects}
\usage{
bru_mapper_fmesher(mesh)

\method{ibm_n}{bru_mapper_fmesher}(mapper, ...)

\method{ibm_values}{bru_mapper_fmesher}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_fmesher}(mapper, input, ...)
}
\arguments{
\item{mesh}{An \code{fmesher} object to map, supported by
\link[fmesher:fm_basis]{fmesher::fm_basis}\verb{(mesh, input)} and
\link[fmesher:fm_dof]{fmesher::fm_dof}\code{(mesh)}.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}
}
\value{
A \code{bru_mapper_fmesher} object.
}
\description{
Creates a mapper for general \code{fmesher} function space objects.
}
\details{
For \code{fmesher} before version "0.2.0.9002", \link[fmesher:fm_mesh_1d]{fmesher::fm_mesh_1d}
objects will be handed over to \code{\link[=bru_mapper.fm_mesh_1d]{bru_mapper.fm_mesh_1d()}}, which handles NA
inputs for older fmesher versions.
}
\examples{
m <- bru_mapper_fmesher(fmesher::fmexample$mesh)
ibm_n(m)
ibm_eval(m, as.matrix(expand.grid(-2:2, -2:2)), seq_len(ibm_n(m)))

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
