% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log_offset}
\alias{bru_log_offset}
\alias{bru_log_index}
\title{Position methods for \code{bru_log} objects}
\usage{
bru_log_offset(x = NULL, bookmark = NULL, offset = NULL)

bru_log_index(x = NULL, i, verbosity = NULL)
}
\arguments{
\item{x}{A \code{bru_log} object. If \code{NULL}, the global \code{inlabru} log is used.}

\item{bookmark}{character; The label for a bookmark with a stored offset.}

\item{offset}{integer; a position offset in the log, with \code{0L} pointing at
the start of the log. If negative, denotes the point \code{abs(offset)} elements
from tail of the log. When \code{bookmark} is non-NULL, the \code{offset} applies a
shift (forwards or backwards) to the bookmark list.}

\item{i}{indices specifying elements to extract. If \code{character}, denotes
the sequence between bookmark \code{i} and the next bookmark (or the end of the
log if \code{i} is the last bookmark)}

\item{verbosity}{integer value for limiting the highest verbosity level being
returned.}
}
\description{
Position methods for \code{bru_log} objects.
}
\section{Functions}{
\itemize{
\item \code{bru_log_offset()}: Utility function for computing log position offsets.

\item \code{bru_log_index()}: Utility function for computing index vectors
for \code{bru_log} objects.

}}
\seealso{
Other inlabru log methods: 
\code{\link{bru_log}()},
\code{\link{bru_log_bookmark}()},
\code{\link{bru_log_message}()},
\code{\link{bru_log_new}()},
\code{\link{bru_log_reset}()}
}
\concept{inlabru log methods}
