# Influx OSS API Service
#
# No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
#
# The version of the OpenAPI document: 2.0.0
#
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title HealthCheck
#'
#' @description HealthCheck Class
#'
#' @format An \code{R6Class} generator object
#'
#' @field name  character 
#'
#' @field message  character [optional]
#'
#' @field checks  list( \link{HealthCheck} ) [optional]
#'
#' @field status  character 
#'
#' @field version  character [optional]
#'
#' @field commit  character [optional]
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
HealthCheck <- R6::R6Class(
  'HealthCheck',
  public = list(
    `name` = NULL,
    `message` = NULL,
    `checks` = NULL,
    `status` = NULL,
    `version` = NULL,
    `commit` = NULL,
    initialize = function(
        `name`, `status`, `message`=NULL, `checks`=NULL, `version`=NULL, `commit`=NULL, ...
    ) {
      local.optional.var <- list(...)
      if (!missing(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!missing(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
      if (!is.null(`message`)) {
        stopifnot(is.character(`message`), length(`message`) == 1)
        self$`message` <- `message`
      }
      if (!is.null(`checks`)) {
        stopifnot(is.vector(`checks`), length(`checks`) != 0)
        sapply(`checks`, function(x) stopifnot(R6::is.R6(x)))
        self$`checks` <- `checks`
      }
      if (!is.null(`version`)) {
        stopifnot(is.character(`version`), length(`version`) == 1)
        self$`version` <- `version`
      }
      if (!is.null(`commit`)) {
        stopifnot(is.character(`commit`), length(`commit`) == 1)
        self$`commit` <- `commit`
      }
    },
    toJSON = function() {
      HealthCheckObject <- list()
      if (!is.null(self$`name`)) {
        HealthCheckObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`message`)) {
        HealthCheckObject[['message']] <-
          self$`message`
      }
      if (!is.null(self$`checks`)) {
        HealthCheckObject[['checks']] <-
          lapply(self$`checks`, function(x) x$toJSON())
      }
      if (!is.null(self$`status`)) {
        HealthCheckObject[['status']] <-
          self$`status`
      }
      if (!is.null(self$`version`)) {
        HealthCheckObject[['version']] <-
          self$`version`
      }
      if (!is.null(self$`commit`)) {
        HealthCheckObject[['commit']] <-
          self$`commit`
      }

      HealthCheckObject
    },
    fromJSON = function(HealthCheckJson) {
      HealthCheckObject <- jsonlite::fromJSON(HealthCheckJson)
      if (!is.null(HealthCheckObject$`name`)) {
        self$`name` <- HealthCheckObject$`name`
      }
      if (!is.null(HealthCheckObject$`message`)) {
        self$`message` <- HealthCheckObject$`message`
      }
      if (!is.null(HealthCheckObject$`checks`)) {
        self$`checks` <- ApiClient$new()$deserializeObj(HealthCheckObject$`checks`, "array[HealthCheck]", loadNamespace("influxdbclient"))
      }
      if (!is.null(HealthCheckObject$`status`)) {
        self$`status` <- HealthCheckObject$`status`
      }
      if (!is.null(HealthCheckObject$`version`)) {
        self$`version` <- HealthCheckObject$`version`
      }
      if (!is.null(HealthCheckObject$`commit`)) {
        self$`commit` <- HealthCheckObject$`commit`
      }
      self
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`message`)) {
        sprintf(
        '"message":
          "%s"
                ',
        self$`message`
        )},
        if (!is.null(self$`checks`)) {
        sprintf(
        '"checks":
        [%s]
',
        paste(sapply(self$`checks`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`status`)) {
        sprintf(
        '"status":
          "%s"
                ',
        self$`status`
        )},
        if (!is.null(self$`version`)) {
        sprintf(
        '"version":
          "%s"
                ',
        self$`version`
        )},
        if (!is.null(self$`commit`)) {
        sprintf(
        '"commit":
          "%s"
                ',
        self$`commit`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(HealthCheckJson) {
      HealthCheckObject <- jsonlite::fromJSON(HealthCheckJson)
      self$`name` <- HealthCheckObject$`name`
      self$`message` <- HealthCheckObject$`message`
      self$`checks` <- ApiClient$new()$deserializeObj(HealthCheckObject$`checks`, "array[HealthCheck]", loadNamespace("influxdbclient"))
      self$`status` <- HealthCheckObject$`status`
      self$`version` <- HealthCheckObject$`version`
      self$`commit` <- HealthCheckObject$`commit`
      self
    }
  )
)

