% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-anova.R
\name{infer_oneway_anova}
\alias{infer_oneway_anova}
\alias{owanova}
\title{One Way ANOVA}
\usage{
infer_oneway_anova(data, x, y, ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{character vector; name of a continuous variable from \code{data}}

\item{y}{character vector; name of a categorical variable from \code{data}}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{owanova} returns an object of class \code{"owanova"}.
An object of class \code{"owanova"} is a list containing the
following components:

\item{between}{between group sum of squares}
\item{within}{within group sum of squares}
\item{total}{total sum of squares}
\item{df_btw}{between groups degress of freedom}
\item{df_within}{within groups degress of freedom}
\item{df_total}{total degress of freedom}
\item{ms_btw}{between groups mean square}
\item{ms_within}{within groups mean square}
\item{f}{f value}
\item{p}{p value}
\item{r2}{r squared value}
\item{ar2}{adjusted r squared value}
\item{sigma}{root mean squared error}
\item{obs}{number of observations}
\item{tab}{group statistics}
}
\description{
One way analysis of variance
}
\section{Deprecated Functions}{

\code{owanova()} has been deprecated. Instead use \code{infer_oneway_anova()}.
}

\examples{
infer_oneway_anova(mtcars, 'mpg', 'cyl')
infer_oneway_anova(hsb, 'write', 'prog')
}
\references{
Kutner, M. H., Nachtsheim, C., Neter, J., & Li, W. (2005).
Applied linear statistical models. Boston: McGraw-Hill Irwin.
}
\seealso{
\code{\link[stats]{anova}}
}
