#' Clear and cloudy sky radiative forcing (W m-2) and the contribution of individual absorbers to this total
#'
#' A table containing the "clear and cloudy sky radiative forcing".
#'
#'
#'
#' @format A data.table data frame with 7 rows and 6 variables:
#' \describe{
#' \item{Gas}{Gas Name}
#' \item{Individual contribution (W m^-2)}{Individual contribution in W m^-2 with a clear sky}
#' \item{Individual contribution - Cloudy sky (W m^-2)}{Individual contribution in W m^-2 with a cloudy sky}
#' \item{Combined with overlap effects (W m^-2)}{Combined with overlap effects in W m^-2 with a clear sky}
#' \item{Combined with overlap effects - Cloudy sky (W m^-2)}{Combined with overlap effects in W m^-2 with a cloudy sky}
#' \item{Percent contribution clear sky (W m^-2)}{Percent contribution clear sky in W m^-2}
#' }
#'
#' @source
#' "Earth's Annual Global Mean Energy Budget" By J. T. Kiehl and Kevin E. Trenberth, \emph{Bulletin of the American Meteorological Society}, Vol. 78, No. 2, February 1997, pages 197-208, \url{https://web.archive.org/web/20060330013311/http://www.atmo.arizona.edu/students/courselinks/spring04/atmo451b/pdf/RadiationBudget.pdf}. Retrieved thanks to the Internet Archive: Wayback Machine. Table 3. Clear and cloudy sky radiative forcing (W m-2) and the contribution of individual absorbers to this total. Cloudy sky results are in parentheses from the Reference
#'
#'
#'
#'
"greenhouse_gases_cloudy_sky"
#> [1] "greenhouse_gases_cloudy_sky"
