#' Table 16-5 Relationship of m and PRF for DUH developed from a Gamma equation
#'
#' A table containing the relationship between m and PRF for the distributed
#' unit hydrograph (DUH) developed from a Gamma equation.
#'
#'
#'
#' @format A data.table data frame with 7 rows and 2 variables:
#' \describe{
#' \item{m}{"gamma equation shape factor"}
#' \item{PRF}{"peak rate factor (PRF)"}
#' }
#'
#'
#' @source
#' United States Department of Agriculture (USDA) Natural Resources Conservation Service (NRCS), \emph{National Engineering Handbook}, "Part 630 Hydrology Chapter 16 Hydrographs", Pages 16-4, 16-9, 16-15, \url{https://directives.sc.egov.usda.gov/OpenNonWebContent.aspx?content=17755.wba}
#'
#'
#'
#'
"duh_gamma"
#> [1] "duh_gamma"
