% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im_sace.R
\name{summary.IDEMINFER}
\alias{summary.IDEMINFER}
\title{Summary of the inference results}
\usage{
\method{summary}{IDEMINFER}(object, opt = c("survivor", "SACE"), sace.deltas = NULL, ...)
}
\arguments{
\item{object}{A class \code{IDEMINFER} list generated by \code{\link{imInfer}}}

\item{opt}{Types of the summary
\itemize{
\item{\code{survivor}: }{Survivors only analysis}
\item{\code{SACE}: }{Survivor Averaged Causal Effect}
}}

\item{sace.deltas}{Vector of sensitivity parameters for SACE estimation. If
\code{NULL}, the values will be generated based on the standard
deviations of the estimated differences in the functional outcomes
between the treatment and control arms}

\item{...}{Optional arguments for summary}
}
\value{
A class \code{summary.IDEMINFER} list containing
\describe{
\item{deltas}{imputation sensitivity parameters}
\item{n.boot}{number of bootstrap samples in bootstrap analysis}
\item{sace.deltas}{SACE sensitivity parameters when \code{opt = SACE}}
\item{rst}{A data frame with columns
\itemize{
\item \code{Delta0}: Imputation sensitivity parameter for control arm,
\item \code{Delta1}: Imputation sensitivity parameter for intervention arm
\item \code{SACE_Delta}: SACE sensitivity parameter when \code{opt = SACE}
\item \code{Effect}: SACE estimate
\item \code{LB}: Lower bound of the 95% CI when \code{n.boot > 0} in the \code{IDEMINFER} object
\item \code{UB}: Upper bound of the 95% CI when \code{n.boot > 0} in the \code{IDEMINFER} object
\item \code{PValue}: p-value when when \code{n.boot > 0} in the \code{IDEMINFER} object
}}}
}
\description{
Summarize survivors only or Survivor Averaged Causal Effect (SACE) based on
the imputation and bootstrap analysis
}
\details{
For SACE, the default sensitivity parameters will be determined by the
standard deviation of the treatment effect size on the functional outcomes.
}
\examples{
\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.fit  <- imFitModel(rst.abc);
rst.imp <- imImpAll(rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);
rst.infer <- imInfer(rst.imp, n.boot = 100, effect.quantiles = c(0.25,0.5,0.75));
rst.sace  <- summary(rst.infer, opt = "SACE")}

}
\references{
Chiba Y, VanderWeele TJ (2011). A simple method for principal strata effects when
the outcome has been truncated due to death. American Journal of Epidemiology 173(7):745-751.
}
