% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{imInfer}
\alias{imInfer}
\title{Treatment effect estimation and hypothesis testing}
\usage{
imInfer(imp.rst, n.boot = 0, n.cores = 1, update.progress = NULL,
  effect.quantiles = 0.5, quant.ci = c(0.025, 0.975), ...,
  seed = NULL)
}
\arguments{
\item{imp.rst}{A class \code{IDEMIMP} object returned from
\code{\link{imImpAll}}}

\item{n.boot}{Number of bootstrap samples}

\item{n.cores}{Number of cores for parallel computation. Fixed at 1 for Windows.}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{effect.quantiles}{Composite quantiles of interest for measuring
treatment effect}

\item{quant.ci}{Quantiles for extracting bootstrap confidence intervals}

\item{...}{Extra options for ranking subjects using the composite endpoint
that include \itemize{ \item{\code{cut.z}: }{ Clinically meaningful difference in
the functional outcome} \item{\code{cut.surv}: }{ Clinically meaningful difference
in survival time}}}

\item{seed}{Random seed}
}
\value{
A class \code{IDEMTEST} list containing

\describe{
\item{lst.var}{List of specification parameters}

\item{deltas}{Vector of sensitivity parameters}

\item{theta}{A data frame with columns
\itemize{
\item \code{Delta0}: Sensitivity parameter for control arm
\item \code{Delta1}: Sensitivity parameter for intervention arm
\item \code{Theta}: Estimated \eqn{\theta}
\item \code{SD}: Standard deviation (when \code{n.boot >0})
\item \code{PValue}: p-value (when \code{n.boot >0}}
}

\item{effect.quantiles}{A data frame with columns

\itemize{
\item \code{Delta}:Sensitivity parameter
\item \code{TRT}:Treatment arm
\item \code{Q}: Quantiles of the composite endpoint to be estimated

\item \code{QuantY}: Estimated quantiles if the quantiles correspond to
functional outcome (when \code{n.boot >0})

\item \code{QuantSurv}: Estimated quantiles if the quantiles correspond to
survival days (when \code{n.boot >0})

\item \code{Q}: Boostrap quantiles for the QuantY (when \code{n.boot >0})

\item \code{QSurv}: Boostrap quantiles for the QuantSurv (when
\code{n.boot >0}) }}

\item{bootstrap}{A list with length \code{n.boot}. The \eqn{i}th item is the
    class \code{IDEMEST} list corresponding to the \eqn{i}th bootstrap
    sample} }
}
\description{
Estimate treatment effect size. Estimate variation and conduct hypothesis
testing by bootstrap analysis.
}
\details{
If \code{n.boot=0}, bootstrap analysis will not be conducted. Instead, only
the treatment effect size will be estimated using the imputed data.
}
\examples{
\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.fit  <- imFitModel(rst.abc);
rst.imp <- imImpAll(rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);
rst.est <- imInfer(rst.imp, n.boot = 0, effect.quantiles = c(0.25,0.5,0.75));
rst.test <- imInfer(rst.imp, n.boot = 100, effect.quantiles = c(0.25,0.5,0.75));}

}
