% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imImpSingle}
\alias{imImpSingle}
\title{Impute missing data under benchmark assumption}
\usage{
imImpSingle(dsub, fit.rst, normal = TRUE, chains = 4, iter = 5000,
  warmup = 1000, control = list(adapt_delta = 0.95), ...)
}
\arguments{
\item{dsub}{original individual subject data}

\item{fit.rst}{A class \code{IDEM.FIT} results of linear regression.
See \code{\link{imFitModel}}.}

\item{normal}{Logical variable indicating whether normality assumption should
be made for the residuals}

\item{chains}{STAN parameter. Number of Markov chainsm}

\item{iter}{STAN parameter. Number of iterations}

\item{warmup}{STAN parameter. Number of burnin.}

\item{control}{STAN parameter. See \code{rstan::stan} for details.}

\item{...}{other options to call STAN sampling such as \code{thin},
\code{algorithm}. See \code{rstan::sampling} for details.}
}
\value{
\code{NULL} if there is no missing data for the current subject.

Otherwise, return a class \code{IDEM.IMPSUB} that contains a list with two components
\describe{
    \item{dsub}{original data of the subject}
    \item{rst.stan}{A \code{stan.fit} class result returned from \code{rstan::sampling}}
    \item{complete}{A dataframe with complete data for the selected subject}
}
}
\description{
Call STAN model to impute missing data for an individual subject under
benchmark assumption
}
\examples{

lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFitModel(abc, lst.var);
rst.imp <- imImpSingle(abc[1,], rst.fit, chains = 4, iter = 2000, warmup = 1000);
rstan::traceplot(rst.imp$rst.stan, "YMIS");

}
