% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ichimoku}
\alias{plot.ichimoku}
\title{Plot Ichimoku Cloud Chart}
\usage{
\method{plot}{ichimoku}(
  x,
  window,
  ticker,
  subtitle,
  theme = c("classic", "dark", "mono", "noguchi", "okabe-ito", "solarized"),
  strat = TRUE,
  type = c("none", "r", "s", "bar", "line"),
  custom,
  ...
)
}
\arguments{
\item{x}{an object of class \sQuote{ichimoku}.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for \sQuote{xts} objects, for
example "2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{subtitle}{(optional) specify a subtitle to display under the chart
title.}

\item{theme}{[default 'classic'] with further choices of \sQuote{dark},
\sQuote{mono}, \sQuote{noguchi}, \sQuote{okabe-ito} or \sQuote{solarized}.
Alternatively, supply a vector of 12 colour values (hex codes or names)
as a user-defined theme.}

\item{strat}{[default TRUE] if the ichimoku object contains a strategy, the
periods for which the strategy results in a position will be shaded, and
the strategy printed as the chart subtitle (if not otherwise specified).
Set to FALSE to turn off this behaviour.}

\item{type}{[default 'none'] type of sub-plot to display beneath the ichimoku
cloud chart, with a choice of \sQuote{none}, \sQuote{r} or \sQuote{s} for
the corresponding oscillator type, and \sQuote{bar} or \sQuote{line} for
custom plots.}

\item{custom}{(optional) character string (containing a regular expression)
matching the column name of the variable to be displayed as sub-plot.
Specify \code{type = 'bar'} or \code{type = 'line'}, otherwise other type
settings will take precedence.}

\item{...}{additional arguments passed along to the print method for
\sQuote{ggplot} objects.}
}
\value{
The ichimoku object supplied (invisibly). The requested plot is output
    to the graphical device.
}
\description{
Plot Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function plot() for
    class \sQuote{ichimoku}. It can be invoked by calling plot(x) on an
    object \sQuote{x} of class \sQuote{ichimoku}.

    For further details please refer to the reference vignette by calling:
    \code{vignette("reference", package = "ichimoku")}
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
plot(cloud)
plot(cloud, window = "2020-05-01/2020-12-01", theme = "dark")
plot(cloud, window = "2020-05/", ticker = "TKR Co.", theme = "noguchi", type = "s")
plot(cloud, window = "/2020-11-02", subtitle = "Sample Price Data", theme = "mono", type = "r")

kumo <- ichimoku(sample_ohlc_data, ticker = "TKR", keep.data = TRUE)
plot(kumo, window = "2020-05/", theme = "solarized", type = "bar", custom = "volume")
plot(kumo, window = "2020-05/", theme = "okabe-ito", type = "line", custom = "volume")

}
