% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{look}
\alias{look}
\title{Look at Informational Attributes}
\usage{
look(x = .Last.value)
}
\arguments{
\item{x}{an object (optional). If \sQuote{x} is not supplied,
\code{\link{.Last.value}} will be used instead.}
}
\value{
For objects created by the ichimoku package, a list of attributes
    specific to that data type.

    For other objects, a list of non-standard attributes for matrix /
    data.frame / xts classes, or else invisible NULL if none are present.
}
\description{
Inspect the informational attributes of objects.
}
\details{
Note: autostrat list attributes may be accessed directly using
    \code{look(x)$logret} and \code{look(x)$summary}.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
look(cloud)

stratlist <- autostrat(cloud, n = 3)
look(stratlist)

strat <- stratlist[[1]]
look(strat)

grid <- mlgrid(cloud)
look(grid)

\dontrun{
# OANDA API key required to run this example
prices <- oanda("USD_JPY")
look(prices)
}

}
