#' @name icesVocab-package
#'
#' @aliases icesVocab
#'
#' @title Vocabularies Database Web Services
#'
#' @description
#' R interface to access the web services of the ICES Vocabularies database of
#' reference codes.
#'
#' @details
#' \emph{Get full tables:}
#' \tabular{ll}{
#'   \code{\link{getCodeTypeList}} \tab all code code types\cr
#'   \code{\link{getCodeList}}     \tab codes of a given type\cr
#'   \code{\link{getCodeDetail}}   \tab details for a given code
#' }
#' \emph{Look up specific codes:}
#' \tabular{ll}{
#'   \code{\link{findAphia}} \tab species code
#' }
#'
#' @author Colin Millar and Arni Magnusson.
#'
#' @references
#' ICES Vocabularies database: \url{http://vocab.ices.dk}.
#'
#' ICES Vocabularies web services: \url{http://vocab.ices.dk/services/POX.aspx}.
"_PACKAGE"
