% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_merge_manual.R
\name{ifcb_merge_manual}
\alias{ifcb_merge_manual}
\title{Merge IFCB Manual Classification Data}
\usage{
ifcb_merge_manual(
  class2use_file_base,
  class2use_file_additions,
  class2use_file_output = NULL,
  manual_folder_base,
  manual_folder_additions,
  manual_folder_output,
  do_compression = TRUE,
  temp_index_offset = 50000,
  skip_class = NULL,
  quiet = FALSE
)
}
\arguments{
\item{class2use_file_base}{Character. Path to the \code{class2use} file of the base manual classifications.
The base set contains the original manual classifications list that form the foundation for merging.}

\item{class2use_file_additions}{Character. Path to the \code{class2use} file of the additions manual classifications.
The additions set contains additional classifications that need to be merged with the base set.
Class labels from the \code{class2use_file_additions} that are not already included in the \code{class2use_file_base} will be added to generate the \code{class2use_file_output}.}

\item{class2use_file_output}{Character. Path where the merged \code{class2use} file will be saved.
If \code{NULL}, the merged file will be stored in the same directory as \code{class2use_file_base}. Default is \code{NULL}.}

\item{manual_folder_base}{Character. Path to the folder containing the base set of manual classification \code{.mat} files.}

\item{manual_folder_additions}{Character. Path to the folder containing the additions set of manual classification \code{.mat} files.}

\item{manual_folder_output}{Character. Path to the output folder where the merged classification files will be stored.}

\item{do_compression}{A logical value indicating whether to compress the \code{.mat} file. Defaults to \code{TRUE}.}

\item{temp_index_offset}{Numeric. A large integer used to generate temporary indices during the merge process. Default is 50000.}

\item{skip_class}{Character. A vector of class names to skip from the \code{class2use_file_additions} during the merge process. Default is \code{NULL}.}

\item{quiet}{Logical. If \code{TRUE}, suppresses output messages. Default is \code{FALSE}.}
}
\value{
No return value. Outputs the combined \code{class2use} file in the same folder as \code{class2use_file_base} is located or at a user-specified location,
and merged \code{.mat} files into the output folder.
}
\description{
This function merges two sets of manual classification data by combining
and aligning class labels from a base set and an additional set of classifications.
The merged \code{.mat} data can be used with the code in the \code{ifcb-analysis} repository (Sosik and Olson 2007).
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

The \strong{base} set consists of the original classifications that are used as a reference for the merging process.
The \strong{additions} set contains the additional classifications that need to be merged with the base set.
When merging, unique class names from the additions set that are not present in the base set are appended.

The function works by aligning the class labels from the additions set with those in the base set,
handling conflicts by using a temporary index system. It copies \code{.mat} files from both the base and
additions folders into the output folder, while adjusting indices and and class names for the additions.

Note that the maximum limit for \code{uint16} is 65,535, so ensure that \code{temp_index_offset} remains below this value.
}
\examples{
\dontrun{
ifcb_merge_manual("path/to/class2use_base.mat", "path/to/class2use_additions.mat",
                  "path/to/class2use_combined.mat", "path/to/manual/base_folder",
                  "path/to/manual/additions_folder", "path/to/manual/output_folder",
                  do_compression = TRUE, temp_index_offset = 50000, quiet = FALSE)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \url{https://github.com/hsosik/ifcb-analysis}
}
