% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iNextPD.R
\name{iNextPD}
\alias{iNextPD}
\title{iNterpolation and EXTrapolation of Hill number}
\usage{
iNextPD(x, labels, phy, q = 0, datatype = "abundance", size = NULL,
  endpoint = NULL, knots = 40, se = FALSE, conf = 0.95, nboot = 50)
}
\arguments{
\item{x}{a matrix, data.frame (species by sites), or list of species abundances or incidence data.}

\item{labels}{species names for object x.}

\item{phy}{a phylog objcet for input phylo-tree.}

\item{q}{a numeric value specifying the diversity order of Hill number .}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{size}{an integer vector of sample sizes (number of individuals or sampling units) for which diversity estimates will be computed. 
If NULL, then diversity estimates will be computed for those sample sizes determined by the specified/default \code{endpoint} and \code{knots} .}

\item{endpoint}{an integer specifying the sample size that is the \code{endpoint} for rarefaction/extrapolation. 
If NULL, then \code{endpoint} \code{=} double reference sample size.}

\item{knots}{an integer specifying the number of equally-spaced \code{knots} (say K, default is 40) between size 1 and the \code{endpoint};
each knot represents a particular sample size for which diversity estimate will be calculated.  
If the \code{endpoint} is smaller than the reference sample size, then \code{iNextPD()} computes only the rarefaction esimates for approximately K evenly spaced \code{knots}. 
If the \code{endpoint} is larger than the reference sample size, then \code{iNextPD()} computes rarefaction estimates for approximately K/2 evenly spaced \code{knots} between sample size 1 and the reference sample size, and computes extrapolation estimates for approximately K/2 evenly spaced \code{knots} between the reference sample size and the \code{endpoint}.}

\item{se}{a logical variable to calculate the bootstrap standard error and \code{conf} confidence interval.}

\item{conf}{a positive number < 1 specifying the level of confidence interval, default is 0.95.}

\item{nboot}{an integer specifying the number of replications.}
}
\value{
a list of three objects: \code{$DataInfo} for summarizing data information; 
\code{$iNextPDEst} for showing diversity estimates for rarefied and extrapolated samples along with related statistics;
\code{$AsyPDEst} for showing asymptotic diversity estimates along with related statistics, and \code{$ExpandData} (xi, Li, i=1,2,...,B).
}
\description{
\code{iNextPD}: Interpolation and extrapolation of Hill number with order q.
}
\examples{
data(bird)
bird.abu <- bird$abun
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
iNextPD(bird.abu, labels=bird.lab, phy=bird.phy, q=0, datatype="abundance")
}

