% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_cat.R
\name{convertToCat}
\alias{convertToCat}
\title{Convert numeric variables to categorical}
\usage{
convertToCat(.data, vars, names = paste(vars, "cat", sep = "."))
}
\arguments{
\item{.data}{a dataframe with the categorical column to convert}

\item{vars}{a character vector of numeric column names to convert}

\item{names}{a character vector of names for the created variable(s)}
}
\value{
original dataframe containing a new column of the
        converted numeric variable with tidyverse code attached
}
\description{
Convert specified numeric variables into factors
}
\examples{
converted <- convertToCat(iris, vars = c("Petal.Width"))
cat(code(converted))
head(converted)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
