% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fimle.lnl.R
\name{fimle.lnl}
\alias{fimle.lnl}
\title{Full Information Maximum Likelihood Estimates in Linear M-model and Linear
Y-model}
\usage{
fimle.lnl(fit.M, fit.Y, X, rho = 0)
}
\arguments{
\item{fit.M}{a fitted model object for mediator. It must be an object
generated by function ``\code{lm}''}

\item{fit.Y}{a fitted model object for outcome. It must be an object
generated by function ``\code{lm}''. It can contain treatment-mediator
interaction}

\item{X}{a character string of the name of the treatment variable}

\item{rho}{a numerical variable specifying the correlation coefficient
between the residual of the M-model and the residual of the Y-model. Its
range is between \code{-1} and \code{1}}
}
\value{
A list containing the following components: \item{M.model}{a data
frame containing the results for the M-model } \item{Y.model}{a data frame
containing the results for the Y-model } \item{Variance.Matrixl}{a matrix of 
variances and covariances of the parameters estimates }
}
\description{
Parameter estimates in system of correlated linear M-model and linear
Y-model with treatment-mediator interaction using the full information
maximum likelihood method.
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
P-values are computed from normal distribution.
}
\examples{

data("jobs", package = "mediation")

fit.M <- lm(job_seek ~ treat + econ_hard + sex + age, data=jobs)
fit.Y <- lm(depress2 ~ treat + job_seek + econ_hard + sex + age, data=jobs)
fimle.lnl(fit.M, fit.Y, "treat", rho=0.2)


fit.M <- lm(job_seek ~ treat + econ_hard + sex + age , data=jobs)
fit.Y <- lm(depress2 ~ treat*job_seek+ econ_hard + sex + age , data=jobs)
fimle.lnl(fit.M, fit.Y, "treat", rho=0.5)

}
\references{
Wang, K. (2018) Identification and estimation in mediation
models with interaction in the presence of unobserved confounders.
Submitted.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{estimates}
