% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hyreg2.R
\name{give_class}
\alias{give_class}
\title{decode classes by the model}
\usage{
give_class(data, model, id_col = NULL)
}
\arguments{
\item{data}{a \code{dataframe}, which was used to estimate the \code{model}}

\item{model}{a flexmix \code{model}object estimated using \code{\link[=hyreg2]{hyreg2()}} or \code{\link[=hyreg2_het]{hyreg2_het()}}}

\item{id_col}{\code{character}-string, name of grouping variable, which must be a column of the provided \code{data}.
the parameter must be specified, if the provided \code{model} was estimated under control for \code{groups}}
}
\value{
\code{dataframe} of two columns, first column named as provided \code{id_col}  or \code{"observation"} if \code{id_col} was not given as
an input. second column named \code{"mod_comp"} indicating the assigned class for this group or observation
}
\description{
This function can be used to decode the classified classes by the model generated using
\code{hyreg2} or \code{hyreg2_het}
}
\examples{
# estimate a model using simulated_data_norm

### using grouping variable id ####
formula <- y ~  -1 + x1 + x2 + x3 | id
k <- 1
stv <- setNames(c(0.2,0.2,0.2,1,1),c(colnames(simulated_data_norm)[3:5],c("sigma","theta")))
control <- list(iter.max = 1000, verbose = 4)

hyflex_mod <- hyreg2(formula = formula,
                    data =  simulated_data_norm,
                    type =  simulated_data_norm$type,
                    stv = stv,
                    k = k,
                    type_cont = "TTO",
                    type_dich = "DCE_A",
                    opt_method = "L-BFGS-B",
                    control = control,
                    latent = "both",
                    id_col = "id"
)
# use of function give_class
give_class(data = simulated_data_norm,
model = hyflex_mod,
id_col = "id")



}
\author{
Svenja Elkenkamp & John Grosser
}
