% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialMap.R
\name{getSpatialMap_mat}
\alias{getSpatialMap_mat}
\title{Replot raster matrix}
\usage{
getSpatialMap_mat(
  matrix,
  title_d = NULL,
  catchment = NULL,
  point = NULL,
  output = "data",
  name = NULL,
  info = FALSE,
  scale = "identity",
  color = NULL,
  ...
)
}
\arguments{
\item{matrix}{A matrix raster, should be the result of \code{getSpatialMap()}, output should be default
or 'data'}

\item{title_d}{A string showing the title of the plot, defaut is NULL.}

\item{catchment}{A catchment file geting from \code{shp2cat()} in the package, if a catchment is available for background.}

\item{point}{A dataframe, showing other information, e.g., location of the gauging stations. The 
the data.frame should be with columes "name, lon, lat, z, value".}

\item{output}{A string showing the type of the output, if \code{output = 'ggplot'}, the returned 
data can be used in ggplot and \code{getSpatialMap_comb()}; if \code{output = 'plot'}, the returned data is the plot containing all 
layers' information, and can be plot directly or used in grid.arrange; if not set, the raster matrix data
will be returned.}

\item{name}{If \code{output = 'ggplot'}, name has to be assigned to your output, in order to differentiate
different outputs in the later multiplot using \code{getSpatialMap_comb}.}

\item{info}{A boolean showing whether the information of the map, e.g., max, mean ..., default is FALSE.}

\item{scale}{A string showing the plot scale, 'identity' or 'sqrt'.}

\item{color}{Most of time you don't have to set this, but if you are not satisfied with the 
default color, you can set your own palette here. e.g., \code{color = c('red', 'blue')}, then
the value from lowest to highest, will have the color from red to blue. More info about color,
please check ?palette().}

\item{...}{\code{title, x, y} showing the title and x and y axis of the plot. e.g. \code{title = 'aaa'}
default is about precipitation.}
}
\value{
A matrix representing the raster map is returned, and the map is plotted.
}
\description{
replot the matrix output from \code{getSpatialMap}, when \code{output = 'data'} or output is default
value.
}
\examples{

\dontrun{
data(tgridData)# the result of \code{loadNcdf}
#the output type of has to be default or 'data'.
a1 <- getSpatialMap(tgridData, method = 'mean')
a2 <- getSpatialMap(tgridData, method = 'max')
a3 <- getSpatialMap(tgridData, method = 'winter')
a4 <- getSpatialMap(tgridData, method = 'summer')
#For example, if we want to investigate the difference between mean value and max.

a5 <- a2 - a1
getSpatialMap_mat(a4)

#Or to investigate the difference between winter value and summer value.
a6 <- a3 - a4
getSpatialMap_mat(a6)

}


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.

\item Hadley Wickham (2007). Reshaping Data with the reshape Package. Journal of Statistical Software,
21(12), 1-20. URL http://www.jstatsoft.org/v21/i12/.

\item Hadley Wickham (2011). The Split-Apply-Combine Strategy for Data Analysis. Journal of Statistical
Software, 40(1), 1-29. URL http://www.jstatsoft.org/v40/i01/.

\item Original S code by Richard A. Becker and Allan R. Wilks. R version by Ray Brownrigg. Enhancements
by Thomas P Minka <tpminka at media.mit.edu> (2015). maps: Draw Geographical Maps. R package version
2.3-11. https://CRAN.R-project.org/package=maps

\item Roger Bivand and Nicholas Lewin-Koh (2015). maptools: Tools for Reading and Handling Spatial
Objects. R package version 0.8-36. https://CRAN.R-project.org/package=maptools

\item Roger Bivand and Colin Rundel (2015). rgeos: Interface to Geometry Engine - Open Source (GEOS). R
package version 0.3-11. https://CRAN.R-project.org/package=rgeos

}
}
