% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sf.afr}
\alias{sf.afr}
\title{Active floodplain along the River Rhine}
\format{
A \code{sf} containing 1 polygon
}
\usage{
sf.afr
}
\description{
This dataset contains a polygon of the active floodplain along
the German, freeflowing parts of the River Rhine from the weir Iffezheim to
the Dutch border in the coordinate reference system
\href{https://spatialreference.org/ref/epsg/25832/}{ETRS 1989 UTM 32N}.

Originally, this polygon was produced for the floodplain status report
(Auenzustandsbericht; Brunotte et al. (2009), Bundesamt für Naturschutz
(2009)) at a scale of 1:25,000. For hydflood it was updated with recent
flood protection measures and manually improved with recent digital
elevation models and aerial images at a scale of < 1:10,000.
}
\references{
\insertRef{brunotte_flussauen_2009}{hydflood}

\insertRef{brunotte_flussauen_data_2009}{hydflood}

\insertRef{bfn_auenzustandsbericht_2009}{hydflood}
}
\seealso{
\code{\link{sf.af}}, \code{\link{sf.afe}}
}
\keyword{datasets}
