% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEM.R
\name{getDEM}
\alias{getDEM}
\title{Function to obtain the digital elevation models for the active
floodplains along the German federal waterways Elbe and Rhine}
\usage{
getDEM(filename = "", ext, crs, ...)
}
\arguments{
\item{filename}{supplies an optional in- and output filename and has to be
type \code{character}.}

\item{ext}{argument of type \code{\link[terra]{SpatExtent}}.}

\item{crs}{argument of type \code{\link[sf:st_crs]{crs}} or
\code{\link[terra]{crs}}. It is
used to select the respective river (Elbe: \href{https://spatialreference.org/ref/epsg/etrs89-utm-zone-33n/}{'ETRS 1989 UTM 33N'}; Rhine:
\href{https://spatialreference.org/ref/epsg/etrs89-utm-zone-32n/}{'ETRS 1989 UTM 32N'})}

\item{\dots}{additional arguments as for \code{\link[terra]{writeRaster}}.}
}
\value{
\code{SpatRaster} object containing elevation data for the selected
floodplain region.
}
\description{
This function downloads and patches the tiled digital elevation
models (dem) along the German federal waterways Elbe and Rhine that have
been published on \href{https://www.pangaea.de}{pangaea.de}.
}
\details{
Since the underlying tiled digital elevation models (dem) are rather
large datasets hydflood provides options to permanentely cache these
datasets. \code{options("hydflood.datadir" = tempdir())} is the default. To
modify the location of your raster cache to your needs set the respective
\code{options()} prior to loading the package, e.g.
\code{options("hydflood.datadir" = "~/.hydflood");library(hydflood)}. The
location can also be determined through the environmental variable
\env{hydflood_datadir}.

Since downloads of large individual datasets might cause timeouts, it is
recommended to increase \code{options("timeout")}.
}
\examples{
\donttest{
  options("hydflood.datadir" = tempdir())
  options("timeout" = 120)
  library(hydflood)
  dem <- getDEM(ext = ext(c(309000, 310000, 5749000, 5750000)),
                crs = st_crs("EPSG:25833"))
}

}
\references{
\insertRef{weber_dgms_2020}{hydflood}

\insertRef{weber_dgm_elbe_2020}{hydflood}

\insertRef{weber_dgm_rhine_2020}{hydflood}
}
