% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_qualite_nappes.R
\name{get_qualite_nappes_analyses}
\alias{get_qualite_nappes_analyses}
\alias{get_qualite_nappes_stations}
\title{Retrieve data from API "Qualité des nappes d'eau souterraines"}
\usage{
get_qualite_nappes_analyses(...)

get_qualite_nappes_stations(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
The data originate from the "ADES" database (\url{https://ades.eaufrance.fr/}).
Available endpoints are:
\itemize{
\item \code{get_qualite_nappes_stations} retrieves measuring stations for groundwater quality
\item \code{get_qualite_nappes_analyses} retrieves the result analysis of quality measurement
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-qualite-nappes}
}
\examples{
\dontrun{
# List of available filter parameters on 'get_qualite_nappes_stations'
list_params("qualite_nappes", "stations")

# List of stations available in Hérault department
get_qualite_nappes_stations(code_commune = 34116)

# List of available filter parameters on 'get_qualite_nappes_analyses'
list_params("qualite_nappes", "analyses")

# Get results of analysis realised at Grabels in 2019
get_qualite_nappes_analyses(bss_id = "BSS002GNSA",
                            date_debut_prelevement = "2019-11-12")
}
}
