% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{get_diagnostic}
\alias{get_diagnostic}
\title{Diagnostic Tests for Emulators}
\usage{
get_diagnostic(
  emulator,
  targets = NULL,
  validation = NULL,
  which_diag = "cd",
  stdev = 3,
  cleaned = NULL,
  warn = TRUE,
  kfold = NULL,
  ...
)
}
\arguments{
\item{emulator}{An object of class Emulator}

\item{targets}{If desired, the target values for the output(s) of the system}

\item{validation}{If provided, the emulator is tested against the outputs of these points}

\item{which_diag}{Which diagnostic measure to use (choosing from cd, ce, se above)}

\item{stdev}{For `cd', a measure of the allowed distance from prediction and reality}

\item{cleaned}{Internal for stochastic emulators}

\item{warn}{Should a warning be shown if ce is chosen and no targets provided?}

\item{kfold}{Mainly internal: pre-computed k-fold diagnostic results for output}

\item{...}{Any other parameters to be passed through to subfunctions.}
}
\value{
A data.frame consisting of the input points, output values, and diagnostic measures.
}
\description{
Given an emulator, return a diagnostic measure.
}
\details{
An emulator's suitability can be checked in a number of ways. This function combines all
current diagnostics available in the package, returning a context-dependent data.frame
containing the results.

Comparison Diagnostics (cd): Given a set of points, the emulator expectation and variance
are calculated. This gives a predictive range for the input point, according to the
emulator. We compare this against the actual value given by the simulator: points whose
emulator prediction is further away from the simulator prediction are to be investigated.
This 'distance' is given by \code{stdev}, and an emulator prediction correspondingly
should not be further away from the simulator value than stdev*uncertainty.

Classification Error (ce): Given a set of targets, the emulator can determine implausibility
of a point with respect to the relevant target, accepting or rejecting it as appropriate.
We can define a similar `implausibility' function for the simulator: the combination of
the two rejection schemes gives four classifications of points. Any point where the
emulator would reject the point but the simulator would not should be investigated.

Standardized Error (se): The known value at a point, combined with the emulator expectation
and uncertainty, can be combined to provide a standardized error for a point. This error
should not be too large, in general. but the diagnostic is more useful when looking at
a collection of such measures, where systematic bias or over/underconfidence can be seen.

Which of the diagnostics is performed can be controlled by the \code{which_diag} argument.
If performing classification error diagnostics, a set of targets must be provided; for all
diagnostics, a validation (or holdout) set can be provided. If no such set is given, then
the emulator diagnostics are performed with respect to its training points, using k-fold
cross-validation.
}
\examples{
 # Use the simple SIR model via SIREmulators
 get_diagnostic(SIREmulators$ems$nS, validation = SIRSample$validation)
 # Classification error fails without the set of targets
 get_diagnostic(SIREmulators$ems$nI, SIREmulators$targets, SIRSample$validation, 'ce')
 # No validation set: k-fold cross-validation will be used.
 get_diagnostic(SIREmulators$ems$nR, which_diag = 'se')

}
\seealso{
validation_diagnostics

Other diagnostic functions: 
\code{\link{analyze_diagnostic}()},
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{individual_errors}()},
\code{\link{residual_diag}()},
\code{\link{standard_errors}()},
\code{\link{summary_diag}()},
\code{\link{validation_diagnostics}()}
}
\concept{diagnostic functions}
