% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{individual_errors}
\alias{individual_errors}
\title{Predictive Error Plots}
\usage{
individual_errors(
  em,
  validation,
  errtype = "normal",
  xtype = "index",
  plottype = "normal"
)
}
\arguments{
\item{em}{The emulator to perform diagnostics on}

\item{validation}{The validation set of points with output(s)}

\item{errtype}{The type of individual error to be plotted.}

\item{xtype}{The value to plot against}

\item{plottype}{Whether to plot a standard or Q-Q plot.}
}
\value{
The relevant plot.
}
\description{
Plots the predictive error with respect to a variety of quantities.
}
\details{
The choice of errors to plot is controlled by \code{errtype}, and can be one
of four things: normal, corresponding to the regular standardised errors; eigen,
corresponding to the errors after reordering given by the eigendecomposition
of the emulator covariance matrix; chol, similarly deriving errors after Cholesky
decomposition; and cholpivot, deriving the errors after pivoted Cholesky decomposition.

What the errors are plotted with respect to is controlled by \code{xtype}. The options
are index, which plots them in their order in the validation set; em, which plots errors
with respect to the emulator prediction at that point; and any named parameter of the
model, which plots with respect to the values of that parameter.

Finally, the plot type is controlled by \code{plottype}: this can be one of normal,
which plots the errors; or qq, which produces a Q-Q plot of the errors.

The default output is to plot the standardised errors (with no decomposition)
against the ordering in the validation set; i.e. \code{errtype = "normal"},
\code{xtype = "index"}, \code{plottype = "normal"}.

Some combinations are not permitted, as the output would not be meaningful. Errors
arising from an eigendecomposition cannot be plotted against either emulator prediction
or a particular parameter (due to the transformation induced by the eigendecomposition);
Q-Q plots are not plotted for a non-decomposed set of errors, as the correlation
between errors makes it much harder to interpret.
}
\examples{
i1 <- individual_errors(SIREmulators$ems$nS, SIRSample$validation)
i2 <- individual_errors(SIREmulators$ems$nS, SIRSample$validation, "chol", "em")
i3 <- individual_errors(SIREmulators$ems$nS, SIRSample$validation, "eigen", plottype = "qq")
i4 <- individual_errors(SIREmulators$ems$nS, SIRSample$validation, "cholpivot", xtype = "aSI")

}
\references{
Bastos & O'Hagan (2009) <doi:10.1198/TECH.2009.08019>
}
\seealso{
Other diagnostic functions: 
\code{\link{analyze_diagnostic}()},
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{get_diagnostic}()},
\code{\link{residual_diag}()},
\code{\link{standard_errors}()},
\code{\link{summary_diag}()},
\code{\link{validation_diagnostics}()}
}
\concept{diagnostic functions}
