% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhsmmspec.R
\name{hhsmmspec}
\alias{hhsmmspec}
\title{hhsmm specification}
\usage{
hhsmmspec(
  init,
  transition,
  parms.emission,
  sojourn = NULL,
  dens.emission,
  remission = NULL,
  mstep = NULL,
  semi = NULL
)
}
\arguments{
\item{init}{vector of initial probabilities}

\item{transition}{the transition matrix}

\item{parms.emission}{the parameters of the emission distribution}

\item{sojourn}{the sojourn distribution}

\item{dens.emission}{the probability density function of the emission}

\item{remission}{the random sample generation from the emission distribution}

\item{mstep}{the M step function for the EM algorithm}

\item{semi}{a logical vector of length nstate: the TRUE associated states are considered as semi-markov}
}
\value{
a model of class \code{"hhsmmspec"}
}
\description{
Specify a model of class \code{"hhsmmspec"} using the model parameters
}
\examples{
init = c(1,0)
transition = matrix(c(0,1,1,0),2,2)
parms.emission = list(mix.p=list(c(0.5,0.5),1),
				mu=list(list(c(1,2),c(5,1)),c(2,7)),
              sigma=list(list(diag(2),2*diag(2)),0.5*diag(2)))
sojourn = list(lambda = 1, shift = 5, type = "poisson")
dens.emission = dmixmvnorm
remission = rmixmvnorm
mstep = mixmvnorm_mstep
semi = rep(TRUE,2)
model = hhsmmspec(init,transition,parms.emission,sojourn,dens.emission,remission,mstep,semi)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat,  \email{aftbayat@gmail.com}
}
