% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension-utils.R
\name{update_settings}
\alias{update_settings}
\title{Update default function settings}
\usage{
update_settings(default, ...)
}
\arguments{
\item{default}{named list of default values for settings.}

\item{...}{optional settings values to override the default settings.}
}
\value{
The updated list of settings with updated values.
}
\description{
Uses ellipsis parameter to update a list of default settings.
}
\examples{
foo = function(...) {
  default = list(a=1)
  settings = update_settings(default, ...)
}

\dontrun{foo(a=2, b=3)}
}
\seealso{
Other developer functions: \code{\link{crossref_description}},
  \code{\link{generic_implementations}},
  \code{\link{load_packages}}, \code{\link{valid_pkgname}}
}
\concept{developer functions}
