% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-utils.R
\name{get_breaks}
\alias{get_breaks}
\alias{ggplot_breaks}
\title{Create nice axis breaks for plots}
\usage{
get_breaks(limits, N = 10, max_breaks = 10, int_only = TRUE,
  multiples_only = FALSE, include_bounds = TRUE)

ggplot_breaks(...)
}
\arguments{
\item{limits}{axis limits. May be either a vector of 2 elements with lower and upper bounds, or a
single number (which is the upper bound, the lower bound is then assumed to be 0).}

\item{N}{step size. The eventual intervals will be multiples of the divisors of \code{N} or
multiples of \code{N} when \code{multiples_only} is \code{TRUE}. Defaults to 10.}

\item{max_breaks}{maximum amount of breaks, defaults to 10.}

\item{int_only}{whether only integer divisors of \code{N} may be used as breaks, defaults to \code{TRUE}.}

\item{multiples_only}{whether only multiples of \code{N} can be used as breaks, defaults to \code{FALSE}.}

\item{include_bounds}{whether the resulting breaks should encompass \code{min} and \code{max}. Defaults to \code{TRUE}.}

\item{...}{Arguments passed on to \code{get_breaks}
\describe{
  \item{limits}{axis limits. May be either a vector of 2 elements with lower and upper bounds, or a
single number (which is the upper bound, the lower bound is then assumed to be 0).}
  \item{N}{step size. The eventual intervals will be multiples of the divisors of \code{N} or
multiples of \code{N} when \code{multiples_only} is \code{TRUE}. Defaults to 10.}
  \item{max_breaks}{maximum amount of breaks, defaults to 10.}
  \item{int_only}{whether only integer divisors of \code{N} may be used as breaks, defaults to \code{TRUE}.}
  \item{multiples_only}{whether only multiples of \code{N} can be used as breaks, defaults to \code{FALSE}.}
  \item{include_bounds}{whether the resulting breaks should encompass \code{min} and \code{max}. Defaults to \code{TRUE}.}
}}
}
\value{
A sorted numerical vector with breaks of length \code{|max_breaks|+2} when \code{include_bounds} is \code{TRUE}
and of size \code{|max_breaks|} otherwise.
}
\description{
Set the breaks for a graph in nice positions.
}
\details{
\code{get_breaks} is the base function and creates a vector of breaks \code{ggplot_breaks} is a wrapper and
makes usage easier in \pkg{ggplot2}. The limits of the axis may not be known beforehand,
but \code{ggplot_breaks} receives it from \code{ggplot} and then creates nice breaks.
}
\examples{
get_breaks(24, N=12, max_breaks=15)

\dontrun{
ggplot() + scale_x_continuous(breaks = ggplot_breaks(N=12, max_breaks=15))}

}
\concept{break functions}
