% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension-utils.R
\name{valid_pkgname}
\alias{valid_pkgname}
\alias{valid_funcname}
\title{Validate package and function names}
\usage{
valid_pkgname(pkg)

valid_funcname(func)
}
\arguments{
\item{pkg}{string vector containing package names. Can be a vector of strings with size of at least 1.}

\item{func}{string vector containing function names. Can be a vector of strings with size of at least 1.}
}
\value{
A named logical indicating whether the package name is valid.
}
\description{
Naming rule obtained from \emph{'Writing R Extensions'} manual.
The corresponding regular expression used for verifying the package name is \code{"[[:alpha:]][[:alnum:]\\.]*[[:alnum:]]"}.
For function names this is \code{"((?:[[:alpha:]]|\\.(?![0-9]))[[:alnum:]_\\.]*)"}
}
\examples{
valid_pkgname("hgutils") # valid
valid_pkgname("ggplot2") # valid
valid_pkgname("pkg2.-1") # invalid

valid_funcname(".hgutils") # valid
valid_funcname("ggplot2") # valid
valid_funcname(".2pkg") # invalid
}
\references{
\code{\link[base]{make.names}}, \href{https://cran.r-project.org/doc/manuals/r-devel/R-exts.html#The-DESCRIPTION-file}{'Writing R Extensions'} manual.
}
\seealso{
Other developer functions: 
\code{\link{crossref_description}()},
\code{\link{generic_implementations}()},
\code{\link{load_packages}()},
\code{\link{update_settings}()}
}
\concept{developer functions}
