# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Outputs physicist version of Hermite Polynomials
#' 
#' 
#' The method calculates the physicist version of Hermite polynomials, 
#' \eqn{H_k(x)} from \eqn{k=0,\dots,N} for the vector of values, x.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @param x A numeric vector.
#' @return A numeric matrix with N+1 rows and length(x) columns.
#' @export
hermite_polynomial <- function(N, x) {
    .Call(`_hermiter_hermite_polynomial`, N, x)
}

#' Outputs Hermite normalization factors 
#' 
#' The method returns numeric normalization factors that, when multiplied by 
#' the physicist Hermite polynomials times a Gaussian factor i.e.
#' \eqn{\exp{x^2/2}H_k(x)}, yields orthonormal 
#' Hermite functions \eqn{h_k(x)} for \eqn{k=0,\dots,N}.
#'
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @return A numeric vector of length N+1
#' @export
hermite_normalization <- function(N) {
    .Call(`_hermiter_hermite_normalization`, N)
}

#' Outputs orthonormal Hermite functions
#' 
#' 
#' The method calculates the orthonormal Hermite functions, \eqn{h_k(x)} 
#' from \eqn{k=0,\dots,N} for the vector of values, x.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @param x A numeric vector.
#' @return A numeric matrix with N+1 rows and length(x) columns.
#' @export
hermite_function <- function(N, x) {
    .Call(`_hermiter_hermite_function`, N, x)
}

#' Outputs the sum of orthonormal Hermite functions
#' 
#' 
#' The method calculates the sum of orthonormal Hermite functions, 
#' \eqn{\sum_{i} h_k(x_{i})} from \eqn{k=0,\dots,N} for the vector of values,
#' x.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @param x A numeric vector.
#' @return A numeric vector of length N+1.
#' @export
hermite_function_sum_serial <- function(N, x) {
    .Call(`_hermiter_hermite_function_sum_serial`, N, x)
}

#' Outputs lower integral of the orthonormal Hermite functions
#' 
#' The method calculates \eqn{\int_{-\infty}^{x} h_k(t) dt} 
#' for \eqn{k=0,\dots,N} and the vector of values x.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @param x A numeric vector.
#' @param hermite_function_mat A numeric matrix of Hermite function values 
#' generated by the function hermite_function.
#' @return A numeric matrix with N+1 rows and length(x) columns.
#' @export
hermite_integral_val <- function(N, x, hermite_function_mat) {
    .Call(`_hermiter_hermite_integral_val`, N, x, hermite_function_mat)
}

#' Outputs upper integral of the orthonormal Hermite functions
#' 
#' The method calculates \eqn{\int_{x}^{\infty} h_k(t) dt} 
#' for \eqn{k=0,\dots,N} and the vector of values x.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @param x A numeric vector.
#' @param hermite_function_mat A numeric matrix of Hermite function values 
#' generated by the function hermite_function.
#' @return A numeric matrix with N+1 rows and length(x) columns.
#' @export
hermite_integral_val_upper <- function(N, x, hermite_function_mat) {
    .Call(`_hermiter_hermite_integral_val_upper`, N, x, hermite_function_mat)
}

#' Outputs integral of the orthonormal Hermite functions on the full domain
#' 
#' The method calculates \eqn{\int_{-\infty}^{\infty} h_k(t) dt} 
#' for \eqn{k=0,\dots,N}.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param N An integer number.
#' @return A numeric matrix with N+1 rows and 1 columns.
#' @export
hermite_int_full_domain <- function(N) {
    .Call(`_hermiter_hermite_int_full_domain`, N)
}

#' Standardizes the observation x and updates the online moment inputs
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#' 
#' @param x A numeric value.
#' @param n_obs A numeric value. The number of observations.
#' @param current_mean A numeric value. 
#' @param current_var A numeric value. 
#' @return A numeric vector. The first element is the updated mean. The
#' second element is the updated variance times n_obs. The third element is the
#' updated, standardized value of x.
#' @export
standardizeInputs <- function(x, n_obs, current_mean, current_var) {
    .Call(`_hermiter_standardizeInputs`, x, n_obs, current_mean, current_var)
}

#' Standardizes the observation x and updates the online moment inputs
#' 
#' The online moments are updated via exponential weighting.
#' 
#' @author Michael Stephanou <michael.stephanou@gmail.com>
#'
#' @param x A numeric value.
#' @param n_obs A numeric value. The number of observations.
#' @param lambda A numeric value.
#' @param current_mean A numeric value.
#' @param current_var A numeric value.  
#' @return A numeric vector. The first element is the updated mean. The
#' second element is the updated variance times n_obs. The third element is the
#' updated, standardized value of x.
#' @export
standardizeInputsEW <- function(x, n_obs, lambda, current_mean, current_var) {
    .Call(`_hermiter_standardizeInputsEW`, x, n_obs, lambda, current_mean, current_var)
}

hermite_function_sum_parallel <- function(N, x) {
    .Call(`_hermiter_hermite_function_sum_parallel`, N, x)
}

