% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{summary.hermite_estimator_bivar}
\alias{summary.hermite_estimator_bivar}
\title{Summarizes bivariate hermite_estimator object.}
\usage{
\method{summary}{hermite_estimator_bivar}(object, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{A hermite_estimator_bivar object.}

\item{digits}{A numeric value. Number of digits to round to.}

\item{...}{Other arguments passed on to methods used in summary.}
}
\description{
Outputs key parameters of a bivariate hermite_estimator object along with
estimates of the mean and standard deviation of the first and second 
dimensions of the bivariate data that the object has been updated with.
Also outputs the Spearman's Rho and Kendall Tau of the bivariate data that 
the object has been updated with.
}
\examples{
hermite_est <- hermite_estimator_bivar(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, matrix(rnorm(30*2), nrow=30, 
ncol=2, byrow = TRUE))
summary(hermite_est)
}
