% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vigitel.R
\name{vigitel_download}
\alias{vigitel_download}
\title{Download VIGITEL microdata for a specific year}
\usage{
vigitel_download(year, force = FALSE)
}
\arguments{
\item{year}{Integer. Year of the survey (use \code{vigitel_years()} to see
available years).}

\item{force}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
Path to the downloaded file (invisibly)
}
\description{
Downloads the VIGITEL survey microdata file from the Ministry of Health
website. Files are cached locally to avoid repeated downloads.
}
\examples{
\donttest{
# download 2023 data
vigitel_download(2023)

# force re-download
vigitel_download(2023, force = TRUE)
}
}
