% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mixturecure}
\alias{predict.mixturecure}
\title{Predicted probabilities for susceptibles, linear predictor for latency, and risk class for latency for mixture cure fit}
\usage{
\method{predict}{mixturecure}(object, newdata, model.select = "AIC", ...)
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, \code{cv_cureem}.}

\item{newdata}{an optional data.frame that minimally includes the incidence and/or latency variables to use for predicting the response. If omitted, the training data are used.}

\item{model.select}{for models fit using \code{curegmifs} or \code{cureem} any step along the solution path can be selected. The default is \code{model.select = "AIC"} which calculates the predicted values using the coefficients from the model having the lowest AIC. Other options are \code{model.select = "mAIC"} for the modified AIC,  \code{model.select = "cAIC"} for the corrected AIC, \code{model.select = "BIC"}, \code{model.select = "mBIC"} for the modified BIC, \code{model.select = "EBIC"} for the extended BIC, \code{model.select = "logLik"} for the step that maximizes the log-likelihood, or any numeric value from the solution path. This option has no effect for objects fit using \code{cv_curegmifs} or \code{cv_cureem}.}

\item{...}{other arguments}
}
\value{
\item{p.uncured}{ a vector of probabilities from the incidence portion of the fitted model representing the P(uncured).}

\item{linear.latency}{ a vector for the linear predictor from the latency portion of the model.}

\item{latency.risk}{ a dichotomous class representing low (below the median) versus high risk for the latency portion of the model.}
}
\description{
This function returns a list the includes the predicted probabilities for susceptibles as well as the linear predictor for the latency distribution and a dichotomous risk for latency for a \code{curegmifs}, \code{cureem}, \code{cv_curegmifs} or \code{cv_cureem} fitted object.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
fit <- curegmifs(Surv(Time, Censor) ~ .,
                  data = training, x.latency = training,
                  model = "weibull", thresh = 1e-4, maxit = 2000,
                  epsilon = 0.01, verbose = FALSE)
predict.train <- predict(fit)
names(predict.train)
testing <- temp$Testing
predict.test <- predict(fit, newdata = testing)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}}, \code{\link{coef.mixturecure}}, \code{\link{summary.mixturecure}}, \code{\link{plot.mixturecure}}
}
\keyword{methods}
