% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_fft_amoc_cusum.R
\name{hanr_fft_amoc_cusum}
\alias{hanr_fft_amoc_cusum}
\title{Anomaly Detector using FFT with AMOC and CUSUM Cutoff}
\usage{
hanr_fft_amoc_cusum()
}
\value{
\code{hanr_fft_amoc_cusum} object
}
\description{
This function implements an anomaly detection method based on the Fast Fourier daltoolbox::transform (FFT)
and a changepoint-based cutoff strategy using the AMOC (At Most One Change) algorithm applied
to the cumulative sum (CUSUM) of the power spectrum.

The method first computes the FFT of the input time series and extracts the power spectrum.
It then applies a CUSUM transformation to the spectral data to emphasize gradual changes or
shifts in spectral energy. Using the AMOC algorithm, it detects a single changepoint in the
CUSUM-transformed spectrum, which serves as a cutoff index to remove the lower-frequency components.

The remaining high-frequency components are then reconstructed into a time-domain signal
via inverse FFT, effectively isolating rapid or local deviations. Anomalies are detected
by evaluating the distance between this filtered signal and the original series,
highlighting points that deviate significantly from the expected pattern.

This method is suitable for series where spectral shifts are subtle and a single significant
change in behavior is expected.

This function extends the HARBINGER framework and returns an object of class \code{hanr_fft_amoc_cusum}.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series fft detector
model <- hanr_fft_amoc_cusum()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
