% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_red.R
\name{hcp_red}
\alias{hcp_red}
\title{Anomaly and change point detector using RED}
\usage{
hcp_red(
  sw_size = 30,
  noise = 0.001,
  trials = 5,
  red_cp = TRUE,
  volatility_cp = TRUE,
  trend_cp = TRUE
)
}
\arguments{
\item{sw_size}{sliding window size (default 30)}

\item{noise}{noise}

\item{trials}{trials}

\item{red_cp}{red change point}

\item{volatility_cp}{volatility change point}

\item{trend_cp}{trend change point}
}
\value{
\code{hcp_red} object
}
\description{
Anomaly and change point detection using RED
The RED model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the hht library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_red()

# fitting the model
model <- fit(model, dataset$serie)

# execute the detection method
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
