% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcd_eddm.R
\name{hcd_eddm}
\alias{hcd_eddm}
\title{Adapted Early Drift Detection Method (EDDM) method}
\usage{
hcd_eddm(
  min_instances = 30,
  min_num_errors = 1,
  warning_level = 0.95,
  out_control_level = 0.9
)
}
\arguments{
\item{min_instances}{The minimum number of instances before detecting change}

\item{min_num_errors}{The minimum number of errors before detecting change}

\item{warning_level}{Necessary level for warning zone}

\item{out_control_level}{Necessary level for a positive drift detection}
}
\value{
\code{hcp_eddm} object
}
\description{
EDDM (Early Drift Detection Method) aims to improve the detection rate of gradual concept drift in DDM, while keeping a good performance against abrupt concept drift. \url{doi:2747577a61c70bc3874380130615e15aff76339e}
}
\examples{
library("daltoolbox")
library("ggplot2")
set.seed(6)

# Loading the example database
data(har_examples)

#Using example 1
dataset <- har_examples$example1
cut_index <- 60
srange <- cut_index:row.names(dataset)[nrow(dataset)]
drift_size <- nrow(dataset[srange,])
dataset[srange, 'serie'] <- dataset[srange, 'serie'] + rnorm(drift_size, mean=0, sd=0.5)
head(dataset)

plot(x=row.names(dataset), y=dataset$serie, type='l')

# Setting up time series regression model
model <- hanct_kmeans()

# Fitting the model
model <- fit(model, dataset$serie)

# Making detection using hanr_ml
detection <- detect(model, dataset$serie)

# Filtering detected events
print(detection[(detection$event),])

# Drift test

drift_evaluation <- data.frame(!(detection$event == dataset$event)) * 1
model <- fit(hcd_eddm(min_instances=10), drift_evaluation)
detection_drift <- detect(model, drift_evaluation)

grf <- har_plot(model, dataset$serie, detection_drift)
grf <- grf + ylab("value")
grf <- grf

plot(grf)
}
