% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_eval.R
\name{har_eval}
\alias{har_eval}
\title{Evaluation of event detection}
\usage{
har_eval()
}
\value{
\code{har_eval} object
}
\description{
Evaluation of event detection (traditional hard evaluation)
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using the time series 14
dataset <- har_examples$example14
head(dataset)

# setting up time change point using GARCH
model <- hcp_garch()

# fitting the model
model <- fit(model, dataset$serie)

# making detections
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

# evaluating the detections
evaluation <- evaluate(har_eval(), detection$event, dataset$event)
print(evaluation$confMatrix)

# ploting the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)
}
