% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{bbox_cql}
\alias{bbox_cql}
\title{Build a BBOX ECQL filter}
\usage{
bbox_cql(x, geom_name, crs)
}
\arguments{
\item{x}{An \code{sf} object providing the reference geometry.}

\item{geom_name}{Character string giving the geometry attribute name
of the WFS layer.}

\item{crs}{A CRS definition (as accepted by \code{\link[sf:st_crs]{sf::st_crs()}}) corresponding
to the WFS layer.}
}
\value{
A character string containing a \code{BBOX} ECQL filter.
}
\description{
Constructs a spatial ECQL \code{BBOX} expression from a reference geometry.
}
\details{
The bounding box is computed from the geometry provided in \code{x}, after
transforming it to the CRS of the target WFS layer. If the layer CRS has
a valid EPSG code, it is included in the ECQL expression.

This function is an internal helper used by \code{\link[=spatial_cql]{spatial_cql()}} and should
not be called directly by users.
}
\seealso{
\code{\link[=spatial_cql]{spatial_cql()}}
}
\keyword{internal}
