% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postVCF.R
\name{ShowSNPDensityPlot}
\alias{ShowSNPDensityPlot}
\title{Function of showing SNP density at chromosome level}
\usage{
ShowSNPDensityPlot(
  densityData,
  binSize,
  densityColorBar = c("grey", "darkgreen", "yellow", "red"),
  chromSet = c(1:22),
  withchr = FALSE
)
}
\arguments{
\item{densityData}{the raw density data generated from vcftools}

\item{binSize}{the bin size set while generating density data}

\item{densityColorBar}{vector Specific the color bar for plotting density plot (generally four colors)}

\item{chromSet}{vector Filtered chrom set which you want to plot (it must be matched with the CHROM column in densityData)}

\item{withchr}{logical If the chromsome labels of density plot is prefixed with "chr".
Note: it cannot work when the filtered chrom set contain other uncommon chrom symbols (e.g. NC0*, etc)}
}
\value{
A ggplot2 object for SNP density plot
}
\description{
Function of showing SNP density at chromosome level
}
\examples{
library(handyFunctions)
data(SNV_1MB_density_data)
ShowSNPDensityPlot(SNV_1MB_density_data, binSize = 1e6, chromSet = c(38:1))

}
