% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.multiscale.R
\name{gwer.multiscale}
\alias{gwer.multiscale}
\title{Multiscale Geographically Weighted Elliptical Regression}
\usage{
gwer.multiscale(
  formula,
  data,
  kernel = "bisquare",
  approach = "CV",
  adaptive = FALSE,
  criterion = "dCVR",
  family = Normal,
  threshold = 1e-05,
  dMats,
  p.vals,
  theta.vals,
  longlat = NULL,
  bws0,
  bw.seled = rep(F, length(bws0)),
  bws.thresholds = rep(0.1, length(dMats)),
  bws.reOpts = 5,
  spdisp = "local",
  verbose = F,
  weights,
  dispersion = NULL,
  na.action = "na.fail",
  hatmatrix = T,
  control = glm.control(epsilon = 1e-04, maxit = 100, trace = F),
  model = FALSE,
  x = FALSE,
  y = TRUE,
  contrasts = NULL,
  parplot = FALSE,
  max.iterations = 2000,
  subset,
  offset,
  predictor.centered = rep(T, length(bws0) - 1),
  nlower = 10,
  ...
)
}
\arguments{
\item{formula}{regression model formula as in \code{glm}.}

\item{data}{model data frame, or may be a SpatialPointsDataFrame or SpatialPolygonsDataFrame as defined in package \pkg{sp}.}

\item{kernel}{function chosen as follows:
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise;
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise}

\item{approach}{specified by CV for cross-validation approach or by AIC corrected (AICc) approach}

\item{adaptive}{defines the type of bandwidth used. either NULL (default) or a proportion between 0 and 1 of observations to include in weighting scheme (k-nearest neighbours).}

\item{criterion}{criterion for determining the convergence of the back-fitting procedure, could be "CVR" or "dCVR", which corespond to the changing value of RSS (CVR) and the differential version (dCVR), respectively; and "dCVR" is used as default.}

\item{family}{a description of the error distribution to be used in the model (see \code{\link{family.elliptical}} for details of family functions).}

\item{threshold}{threshold value to terminate the back-fitting iteration.}

\item{dMats}{a list of distance matrices used for estimating each specific parameter}

\item{p.vals}{a collection of positive numbers used as the power of the Minkowski distance}

\item{theta.vals}{a collection of values used as angles in radians to rotate the coordinate system}

\item{longlat}{TRUE if point coordinates are longitude-latitude decimal degrees, in which case distances are measured in kilometers. If x is a SpatialPoints object, the value is taken from the object itself.}

\item{bws0}{a vector of initializing bandwidths for the back-fitting procedure, of which the length should equal to the number of paramters if specified}

\item{bw.seled}{a vector of boolean variables to determine whether the corresponding bandwidth should be re-selected or not: if TRUE, the corresponding bandwiths for the specific parameters are supposed to be given in bws0; otherwise, the bandwidths for the specific parameters will be selected within the back-fitting iterations.}

\item{bws.thresholds}{threshold values to define whether the bandwidth for a specific parameter has converged or not}

\item{bws.reOpts}{the number times of continually optimizing each parameter-specific bandwidth even though it meets the criterion of convergence, for avoiding sub-optimal choice due to illusion of convergence;}

\item{spdisp}{if TRUE dispersion parameter varies geographically.}

\item{verbose}{if TRUE (default) reports the progress of search for bandwidth.}

\item{weights}{an optional numeric vector of weights to be used in the fitting process.}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{na.action}{a function which indicates what should happen when the data contain NAs (see \code{glm}).}

\item{hatmatrix}{if TRUE, return the hatmatrix as a component of the result.}

\item{control}{a list of parameters for controlling the fitting process. For \code{elliptical} this is passed by \code{glm.control}.}

\item{model}{a logical value indicating whether model frame should be included as a component of the return.}

\item{x}{a logical value indicating whether the response vector used in the fitting process should be returned as components of the return.}

\item{y}{a logical value indicating whether model matrix used in the fitting process should be returned as components of the return.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \code{model.matrix.default}.}

\item{parplot}{if TRUE the parameters boxplots are plotted.}

\item{max.iterations}{maximum number of iterations in the back-fitting procedure.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting as in \code{glm}.}

\item{predictor.centered}{a logical vector of length equalling to the number of predictors, and note intercept is not included; if the element is TRUE, the corresponding predictor will be centered.}

\item{nlower}{the minmum number of nearest neighbours if an adaptive kernel is used}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{gwer}, a list with follow components:   
\item{SDF}{a SpatialPointsDataFrame (may be gridded) or SpatialPolygonsDataFrame object (see package \pkg{sp}) with fit.points, weights, GWR coefficient estimates, dispersion and the residuals in its \code{data} slot.}
\item{coef}{the matrices of coefficients, standard errors and significance values for parameters hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{hat}{hat matrix of the geographically weighted elliptical model.}
\item{lm}{elliptical global regression on the same model formula.}  
\item{results}{a list of results values for fitted geographically weighted elliptical model.}  
\item{bandwidth}{the bandwidth used in geographical weighting function.}
\item{fitted}{the fitted mean values of the geographically weighted elliptical model.}
\item{hatmatrix}{a logical value indicating if hatmatrix was considered}
\item{gweights}{a matrix with the geographical weighting for all local elliptical models.}
\item{family}{the \code{family} object used.}
\item{flm}{a matrix with the fitted values for all local elliptical models.}
\item{adapt}{the \code{adapt} object used.}
\item{gweight}{the \code{gweights} object used.}
\item{spdisp}{the \code{spdisp} object used.}
\item{this.call}{the function call used.}
\item{fp.given}{the \code{fp.given} object used.}
\item{longlat}{the \code{longlat} object used.}
}
\description{
The function fit geographically weighted elliptical regression model to explore the non-stationarity relationshps across differente spatial scales.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), adapt = TRUE)
msgwr.fit.t <- gwer.multiscale(fit.formula, family = Student(3), data = gSRDF, 
                               bws0 = rep(gwer.bw.t, 5), hatmatrix = TRUE, 
                               adaptive = TRUE)
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \doi{10.1111/j.1538-4632.1996.tb00936.x}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{bw.gwer}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Bandwidth}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{model}
\keyword{optimization}
\keyword{regression}
\keyword{weighted}
