% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_isqtls.R
\name{calculate_isqtls}
\alias{calculate_isqtls}
\title{Calculate Isqtls}
\usage{
calculate_isqtls(
  cellType,
  tissueSiteDetailId,
  phenotypeId,
  variantId,
  datasetId = "gtex_v8",
  .return_raw = FALSE
)
}
\arguments{
\item{cellType}{String. "Adipocytes", "Epithelial_cells", "Hepatocytes",
"Keratinocytes", "Myocytes", "Neurons", "Neutrophils".}

\item{tissueSiteDetailId}{String. The ID of the tissue of interest. Can be a
GTEx specific ID (e.g. "Whole_Blood"; use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}}
to see valid values) or an Ontology ID.}

\item{phenotypeId}{String. See
\href{https://www.gtexportal.org/home/faq#splicingPhenotypeId}{GTEx portal FAQs}
for further details.}

\item{variantId}{String. A gtex variant ID.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Calculate your own Cell Specific sQTLs.
\itemize{
\item This service calculates the gene-variant association for any given pair of gene and variant, which may or may not be significant.
\item This requires as input a GENCODE ID, GTEx variant ID, and tissue site detail ID.
}

By default, the calculation is based on the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Dynamic-Association-Endpoints/operation/calculate_ieqtls_api_v2_association_dynieqtl_get}{GTEx Portal API documentation}.
}
\examples{
\dontrun{
# perform request
calculate_isqtls(
  cellType = "Neutrophils",
  tissueSiteDetailId = "Whole_Blood",
  phenotypeId = "chr1:15947:16607:clu_40980:ENSG00000227232.5",
  variantId = "chr1_1099341_T_C_b38"
)
}
}
\seealso{
Other Dynamic Association Endpoints: 
\code{\link{calculate_expression_quantitative_trait_loci}()},
\code{\link{calculate_ieqtls}()},
\code{\link{calculate_splicing_quantitative_trait_loci}()}
}
\concept{Dynamic Association Endpoints}
